<?php
session_start();
require_once 'includes/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'marketing') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id']) && isset($_POST['note'])) {
    $id = (int)$_POST['id'];
    $note = sanitize_input($_POST['note']);
    
    if (updateNote($id, $_SESSION['user_id'], $note)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
} 