<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Create new Spreadsheet object
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set headers
$sheet->setCellValue('A1', 'Target Number');
$sheet->setCellValue('B1', 'Pressed Button');
$sheet->setCellValue('C1', 'Status');

// Add example data (nanti diganti dengan data dari database)
$data = [
    ['081234567890', '1', 'Success'],
    ['081345678901', '2', 'Failed'],
    ['081456789012', '1', 'Success']
];

// Add data starting from row 2
$row = 2;
foreach ($data as $item) {
    $sheet->setCellValue('A' . $row, $item[0]);
    $sheet->setCellValue('B' . $row, $item[1]);
    $sheet->setCellValue('C' . $row, $item[2]);
    $row++;
}

// Set column width
$sheet->getColumnDimension('A')->setWidth(20);
$sheet->getColumnDimension('B')->setWidth(15);
$sheet->getColumnDimension('C')->setWidth(15);

// Format cells as text
$lastRow = count($data) + 1;
$sheet->getStyle('A2:A'.$lastRow)->getNumberFormat()->setFormatCode('@');

// Set headers for download
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="phone_call_report.xlsx"');
header('Cache-Control: max-age=0');

// Create Excel file
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit; 