<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'pojodmoz_callUsr');
define('DB_PASS', 'PMFD9)xLqXBS');
define('DB_NAME', 'pojodmoz_callsa');
define('DB_MKT_NAME', 'pojodmoz_callmkt');

// Inisialisasi koneksi database auth menggunakan PDO
try {
    $db = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
} catch(PDOException $e) {
    error_log("Connection failed: " . $e->getMessage());
    die("Connection failed: " . $e->getMessage());
}

// Inisialisasi koneksi database marketing menggunakan PDO
try {
    $db_mkt = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_MKT_NAME . ";charset=utf8",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
} catch(PDOException $e) {
    error_log("Marketing DB Connection failed: " . $e->getMessage());
    die("Marketing DB Connection failed: " . $e->getMessage());
}

// Fungsi untuk generate CSRF token
function generateCSRFToken() {
    if (!isset($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

// Fungsi untuk verifikasi CSRF token
function verifyCSRFToken($token) {
    if (!isset($_SESSION['csrf_token']) || empty($token)) {
        return false;
    }
    return hash_equals($_SESSION['csrf_token'], $token);
}

// Fungsi untuk sanitize input
function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Fungsi untuk cek login user
function checkUserLogin($table, $username) {
    global $db;
    try {
        $stmt = $db->prepare("SELECT * FROM $table WHERE username = ? AND deleted_at IS NULL");
        $stmt->execute([$username]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        error_log("Check user login error: " . $e->getMessage());
        return false;
    }
}

// Fungsi untuk mengambil data distributed numbers berdasarkan marketing_id
function getDistributedNumbers($marketing_id) {
    global $db_mkt;
    try {
        $stmt = $db_mkt->prepare("
            SELECT * FROM distributed_numbers 
            WHERE marketing_id = ? 
            ORDER BY distributed_at DESC
        ");
        $stmt->execute([$marketing_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        error_log("Get distributed numbers error: " . $e->getMessage());
        return false;
    }
}

// Fungsi untuk update whatsapp clicked status
function updateWhatsappClicked($id, $marketing_id) {
    global $db_mkt;
    try {
        $stmt = $db_mkt->prepare("
            UPDATE distributed_numbers 
            SET whatsapp_clicked = 1,
                whatsapp_clicked_at = NOW()
            WHERE id = ? AND marketing_id = ?
        ");
        return $stmt->execute([$id, $marketing_id]);
    } catch(PDOException $e) {
        error_log("Update whatsapp clicked error: " . $e->getMessage());
        return false;
    }
}

// Fungsi untuk update note
function updateNote($id, $marketing_id, $note) {
    global $db_mkt;
    try {
        $stmt = $db_mkt->prepare("
            UPDATE distributed_numbers 
            SET note = ?
            WHERE id = ? AND marketing_id = ?
        ");
        return $stmt->execute([$note, $id, $marketing_id]);
    } catch(PDOException $e) {
        error_log("Update note error: " . $e->getMessage());
        return false;
    }
}
?> 